/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.smelter;

import com.google.common.collect.ImmutableList;
import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.interactionhandling.ChatPriority;
import com.minecolonies.api.colony.requestsystem.requestable.IRequestable;
import com.minecolonies.api.colony.requestsystem.requestable.StackList;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.coremod.colony.buildings.modules.ItemListModule;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingSmeltery;
import com.minecolonies.coremod.colony.interactionhandling.StandardInteraction;
import com.minecolonies.coremod.colony.jobs.JobSmelter;
import com.minecolonies.coremod.colony.requestable.SmeltableOre;
import com.minecolonies.coremod.entity.ai.basic.AbstractEntityAIUsesFurnace;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.FurnaceTileEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;

public class EntityAIWorkSmelter
extends AbstractEntityAIUsesFurnace<JobSmelter, BuildingSmeltery> {
    private static final double BASE_XP_GAIN = 5.0;
    public static final String ORE_LIST = "ores";

    public EntityAIWorkSmelter(@NotNull JobSmelter job) {
        super(job);
        this.worker.func_98053_h(true);
    }

    @Override
    public Class<BuildingSmeltery> getExpectedBuildingClass() {
        return BuildingSmeltery.class;
    }

    @Override
    protected void extractFromFurnace(FurnaceTileEntity furnace) {
        ItemStack copyStack;
        ItemStack ingots = new InvWrapper((IInventory)furnace).extractItem(2, 64, false);
        int multiplier = ((BuildingSmeltery)this.getOwnBuilding()).ingotMultiplier(this.getSecondarySkillLevel(), this.worker.func_70681_au());
        for (int amount = ingots.func_190916_E() * multiplier; amount > 0; amount -= copyStack.func_190916_E()) {
            copyStack = ingots.func_77946_l();
            if (amount < ingots.func_77976_d()) {
                copyStack.func_190920_e(amount);
            } else {
                copyStack.func_190920_e(ingots.func_77976_d());
            }
            ItemStack resultStack = InventoryUtils.addItemStackToItemHandlerWithResult((IItemHandler)this.worker.getInventoryCitizen(), copyStack);
            if (!ItemStackUtils.isEmpty(resultStack).booleanValue()) {
                resultStack.func_190920_e(resultStack.func_190916_E() + amount / multiplier);
                new InvWrapper((IInventory)furnace).setStackInSlot(2, resultStack);
                return;
            }
            this.worker.getCitizenExperienceHandler().addExperience(5.0);
            this.worker.decreaseSaturationForAction();
        }
    }

    @Override
    protected IRequestable getSmeltAbleClass() {
        return new SmeltableOre(64 * ((BuildingSmeltery)this.getOwnBuilding()).getFurnaces().size());
    }

    @Override
    protected boolean isSmeltable(ItemStack stack) {
        if (ItemStackUtils.isEmpty(stack).booleanValue() || !ItemStackUtils.IS_SMELTABLE.and(itemStack -> IColonyManager.getInstance().getCompatibilityManager().isOre(stack)).test(stack)) {
            return false;
        }
        return !((BuildingSmeltery)this.getOwnBuilding()).getModuleMatching(ItemListModule.class, m -> m.getId().equals(ORE_LIST)).isItemInList(new ItemStorage(stack));
    }

    @Override
    public void requestSmeltable() {
        if (!((BuildingSmeltery)this.getOwnBuilding()).hasWorkerOpenRequestsOfType(this.worker.getCitizenData().getId(), TypeToken.of(this.getSmeltAbleClass().getClass())) && !((BuildingSmeltery)this.getOwnBuilding()).hasWorkerOpenRequestsFiltered(this.worker.getCitizenData().getId(), req -> req.getShortDisplayString().func_150253_a().contains(new TranslationTextComponent("com.minecolonies.coremod.request.smeltableore")))) {
            ImmutableList<ItemStorage> allowedItems = ((BuildingSmeltery)this.getOwnBuilding()).getModuleMatching(ItemListModule.class, m -> m.getId().equals(ORE_LIST)).getList();
            if (allowedItems.isEmpty()) {
                this.worker.getCitizenData().createRequestAsync(this.getSmeltAbleClass());
            } else {
                List<ItemStack> requests = IColonyManager.getInstance().getCompatibilityManager().getSmeltableOres().stream().filter(storage -> !allowedItems.contains(storage)).map(ItemStorage::getItemStack).collect(Collectors.toList());
                if (requests.isEmpty()) {
                    if (this.worker.getCitizenData() != null) {
                        this.worker.getCitizenData().triggerInteraction(new StandardInteraction((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.furnaceuser.noore"), ChatPriority.BLOCKING));
                    }
                } else {
                    this.worker.getCitizenData().createRequestAsync(new StackList(requests, "com.minecolonies.coremod.request.smeltableore", 64 * ((BuildingSmeltery)this.getOwnBuilding()).getFurnaces().size(), 1));
                }
            }
        }
    }
}

